/*
 * Decompiled with CFR 0.152.
 */
package woolpack.crud;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import woolpack.crud.Updatable;
import woolpack.crud.UpdatableFactory;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatableFactoryCacheImpl
implements UpdatableFactory {
    private final Map<Object, Updatable> cacheMap;
    private final UpdatableFactory factory;

    public UpdatableFactoryCacheImpl(Map<Object, Updatable> cacheMap, UpdatableFactory factory) {
        CheckUtils.checkNotNull(factory);
        this.cacheMap = cacheMap;
        this.factory = factory;
    }

    @Override
    public Updatable newInstance(String id, Map<String, List<Object>> map) {
        if (this.cacheMap == null) {
            return this.factory.newInstance(id, map);
        }
        HashMap<String, Object> key = new HashMap<String, Object>(2);
        key.put("name", id);
        key.put("columnSet", map.keySet());
        Updatable updatable = this.cacheMap.get(key);
        if (updatable == null) {
            updatable = this.factory.newInstance(id, map);
            this.cacheMap.put(key, updatable);
        }
        return updatable;
    }
}

