/*
 * Decompiled with CFR 0.152.
 */
package woolpack.crud;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import woolpack.crud.Executable;
import woolpack.crud.Expression;
import woolpack.crud.Fetchable;
import woolpack.crud.InputMapPointer;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedStatementExecutor
implements Executable {
    private final DataSource dataSource;

    public PreparedStatementExecutor(DataSource dataSource) {
        CheckUtils.checkNotNull(dataSource);
        this.dataSource = dataSource;
    }

    @Override
    public void execute(Expression expression, Fetchable fetchable, Map<String, List<Object>> map) {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                PreparedStatement statement = connection.prepareStatement(expression.getQuery());
                try {
                    List<InputMapPointer> inputMapPointerList = expression.getInputMapPointerList();
                    int size = inputMapPointerList.size();
                    int i = 0;
                    while (i < size) {
                        statement.setObject(i + 1, inputMapPointerList.get(i).get(map));
                        ++i;
                    }
                    statement.execute();
                    fetchable.fetch(statement);
                }
                finally {
                    statement.close();
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

