/*
 * Decompiled with CFR 0.152.
 */
package woolpack.crud;

public class MarkableStringBuilder {
    private final StringBuilder sb;
    private final int[] idx;
    private final boolean[] init;

    public MarkableStringBuilder(StringBuilder sb, int count) {
        this.sb = sb;
        this.idx = new int[count];
        this.init = new boolean[count];
    }

    public void append(String s) {
        this.sb.append(s);
    }

    public void append(char c) {
        this.sb.append(c);
    }

    public void mark(int i) {
        this.idx[i] = this.sb.length();
        this.init[i] = true;
    }

    public void insert(int i, String s) {
        int index = this.idx[i];
        this.sb.insert(index, s);
        int l = s.length();
        int j = 0;
        while (j < this.idx.length) {
            if (this.idx[j] >= index) {
                int n = j;
                this.idx[n] = this.idx[n] + l;
            }
            ++j;
        }
    }

    public final void insert(int i, String first, String plural) {
        this.insert(i, this.init[i] ? first : plural);
        this.init[i] = false;
    }

    public String toString() {
        return this.sb.toString();
    }
}

