/*
 * Decompiled with CFR 0.152.
 */
package woolpack.container;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import woolpack.container.ComponentScope;
import woolpack.container.ScopeContainer;
import woolpack.utils.CheckUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentDef {
    private final ComponentScope scope;
    private final Object singletonValue;

    public AbstractComponentDef(ComponentScope scope) {
        CheckUtils.checkNotNull((Object)scope);
        this.scope = scope;
        this.singletonValue = scope == ComponentScope.SINGLETON ? this.newInstance() : null;
    }

    Object getComponent(String key, ScopeContainer scopeContainer) {
        if (this.scope == ComponentScope.SINGLETON) {
            return this.singletonValue;
        }
        if (this.scope == ComponentScope.PROTOTYPE) {
            return this.newInstance();
        }
        if (this.scope == ComponentScope.REQUEST) {
            return this.createPerScope(key, scopeContainer.getRequest());
        }
        if (this.scope == ComponentScope.SESSION) {
            return this.createPerScope(key, scopeContainer.getSession());
        }
        return this.createPerScope(key, scopeContainer.getApplication());
    }

    private Object createPerScope(String key, Map<String, Object> map) {
        Object result;
        while ((result = map.get(key)) == null) {
            map.put(key, this.newInstance());
        }
        return result;
    }

    private Object createPerScope(String key, ConcurrentMap<String, Object> map) {
        Object result;
        while ((result = map.get(key)) == null) {
            map.putIfAbsent(key, this.newInstance());
        }
        return result;
    }

    protected abstract Object newInstance();
}

