/*
 * Decompiled with CFR 0.152.
 */
package woolpack.adapter;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import woolpack.utils.CheckUtils;
import woolpack.utils.NodeFindable;

public class JXP
implements NodeFindable {
    private final String criteria;

    public JXP(String criteria) {
        CheckUtils.checkNotEmpty(criteria);
        this.criteria = criteria;
        JXPathContext.compile((String)criteria);
    }

    public JXP(String attrName, String attrValue) {
        this("//*[@" + attrName + "=\"" + attrValue + "\"]");
        CheckUtils.checkNotNull(attrName);
        CheckUtils.checkNotNull(attrValue);
    }

    public NodeList evaluateList(Object node) {
        final List list = JXPathContext.newContext((Object)node).selectNodes(this.criteria);
        return new NodeList(){

            public Node item(int index) {
                return (Node)list.get(index);
            }

            public int getLength() {
                return list.size();
            }
        };
    }

    public Node evaluateOne(Object node) {
        return (Node)JXPathContext.newContext((Object)node).selectSingleNode(this.criteria);
    }

    public String getCriteria() {
        return this.criteria;
    }
}

