/*
 * Decompiled with CFR 0.152.
 */
package woolpack.visitor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import woolpack.el.ELTargetRuntimeException;
import woolpack.utils.Switchable;
import woolpack.utils.UtilsConstants;
import woolpack.visitor.Acceptable;
import woolpack.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorConstants {
    public static final Acceptable<Object> NULL = new Acceptable<Object>(){

        @Override
        public void accept(Visitor visitor, Object v) {
        }
    };
    public static final Acceptable<Object> ECHO = new Acceptable<Object>(){

        @Override
        public void accept(Visitor visitor, Object v) {
            visitor.visit(v);
        }
    };
    public static final Acceptable<Iterable> ITERABLE = new Acceptable<Iterable>(){

        @Override
        public void accept(Visitor visitor, Iterable v) {
            for (Object child : v) {
                visitor.visit(child);
            }
        }
    };
    public static final Acceptable<Map> MAP = new Acceptable<Map>(){

        @Override
        public void accept(Visitor visitor, Map v) {
            for (Object key : v.keySet()) {
                visitor.visit(key);
                visitor.visit(v.get(key));
            }
        }
    };
    public static final Acceptable<Object> REFLECTION = new Acceptable<Object>(){

        @Override
        public void accept(Visitor visitor, Object v) {
            List<PropertyDescriptor> methodList = VisitorConstants.getGetterList(v.getClass());
            for (PropertyDescriptor property : methodList) {
                Object value = VisitorConstants.get(v, property.getReadMethod());
                visitor.visit(property.getName());
                visitor.visit(value);
            }
        }
    };

    private VisitorConstants() {
    }

    public static final Object get(Object object, Method method) {
        try {
            return method.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ELTargetRuntimeException(e);
        }
    }

    public static final List<PropertyDescriptor> getGetterList(Class clazz) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(beanInfo.getPropertyDescriptors().length);
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = 0;
        int n2 = propertyDescriptorArray.length;
        while (n < n2) {
            String key;
            PropertyDescriptor p = propertyDescriptorArray[n];
            Method m = p.getReadMethod();
            if (m != null && !(key = p.getName()).equals("class")) {
                list.add(p);
            }
            ++n;
        }
        return list;
    }

    public static final List<PropertyDescriptor> getConstructorGetterList(Class clazz) {
        Constructor<?>[] array;
        List<PropertyDescriptor> list = VisitorConstants.getGetterList(clazz);
        Map<Class<?>, PropertyDescriptor> map = UtilsConstants.unoverwritableMap(new HashMap());
        for (PropertyDescriptor p : list) {
            map.put(p.getPropertyType(), p);
        }
        Constructor<?>[] constructorArray = array = clazz.getConstructors();
        int n = 0;
        int n2 = constructorArray.length;
        while (n < n2) {
            Constructor<?> constructor = constructorArray[n];
            List<Class<?>> classList = Arrays.asList(constructor.getParameterTypes());
            if (classList.containsAll(map.keySet()) && map.keySet().containsAll(classList)) {
                ArrayList<PropertyDescriptor> newList = new ArrayList<PropertyDescriptor>();
                for (Class<?> propertyClass : classList) {
                    newList.add((PropertyDescriptor)map.get(propertyClass));
                }
                return newList;
            }
            ++n;
        }
        throw new RuntimeException("not match constructor and parameter.");
    }

    public static <K, V> Acceptable<Switchable<K, V>> switchableAcceptable(final Object defaultKey) {
        return new Acceptable<Switchable<K, V>>(){

            @Override
            public void accept(Visitor visitor, Switchable<K, V> v) {
                for (Object key : v.keys()) {
                    visitor.visit(key);
                    visitor.visit(v.get(key));
                }
                if (defaultKey != null && v.getDefault() != null) {
                    visitor.visit(defaultKey);
                    visitor.visit(v.getDefault());
                }
            }
        };
    }

    public static final <V> Acceptable<V> visitAcceptable(final Object object) {
        return new Acceptable<V>(){

            @Override
            public void accept(Visitor visitor, V v) {
                visitor.visit(object);
            }
        };
    }

    public static final Acceptable serialAcceptable(final Acceptable ... acceptables) {
        return new Acceptable(){

            public void accept(Visitor visitor, Object v) {
                Acceptable[] acceptableArray = acceptables;
                int n = 0;
                int n2 = acceptableArray.length;
                while (n < n2) {
                    Acceptable acceptable = acceptableArray[n];
                    acceptable.accept(visitor, v);
                    ++n;
                }
            }
        };
    }
}

