/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.util.concurrent.Semaphore;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import woolpack.utils.XmlTransformer;
import woolpack.utils.XmlTransformerFactory;

public class XmlTransformerFactorySemaphoreImpl
implements XmlTransformerFactory {
    private final Semaphore[] semaphoreArray;
    private final XmlTransformer[] transformerArray;
    private int position = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlTransformerFactorySemaphoreImpl(XmlTransformerFactory factory, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must be equals or more than 1 but " + length);
        }
        factory.getClass();
        this.semaphoreArray = new Semaphore[length];
        this.transformerArray = new XmlTransformer[length];
        int i = 0;
        while (i < length) {
            this.semaphoreArray[i] = new Semaphore(1);
            XmlTransformerFactory xmlTransformerFactory = factory;
            synchronized (xmlTransformerFactory) {
                this.transformerArray[i] = factory.newInstance();
            }
            ++i;
        }
    }

    public XmlTransformer newInstance() {
        return new XmlTransformer(){

            public void transform(Source xmlSource, Result outputTarget) {
                int i = XmlTransformerFactorySemaphoreImpl.this.position;
                while (true) {
                    if (i < XmlTransformerFactorySemaphoreImpl.this.transformerArray.length) {
                        if (XmlTransformerFactorySemaphoreImpl.this.semaphoreArray[i].tryAcquire()) {
                            try {
                                XmlTransformerFactorySemaphoreImpl.this.transformerArray[i].transform(xmlSource, outputTarget);
                                return;
                            }
                            finally {
                                XmlTransformerFactorySemaphoreImpl.this.semaphoreArray[i].release();
                                XmlTransformerFactorySemaphoreImpl.this.position = (i + 1) % XmlTransformerFactorySemaphoreImpl.this.transformerArray.length;
                            }
                        }
                        Thread.yield();
                        ++i;
                        continue;
                    }
                    i = 0;
                }
            }
        };
    }
}

