/*
 * Decompiled with CFR 0.152.
 */
package woolpack.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParsePosition;
import woolpack.text.DelegateNumberFormat;
import woolpack.text.TextConstants;

public class ToBigIntegerFormat
extends DelegateNumberFormat {
    private static final long serialVersionUID = 1L;

    protected ToBigIntegerFormat(ToBigIntegerFormat format, boolean dummy) {
        super(format, dummy);
    }

    public ToBigIntegerFormat(NumberFormat format) {
        super(format);
    }

    public ToBigIntegerFormat() {
        super(TextConstants.getToBigDecimalFormat());
    }

    public Number parse(String source, ParsePosition parsePosition) {
        ParsePosition pp = new ParsePosition(0);
        pp.setIndex(parsePosition.getIndex());
        pp.setErrorIndex(parsePosition.getErrorIndex());
        Number n = super.parse(source, pp);
        if (n != null) {
            if (n instanceof BigInteger) {
                parsePosition.setIndex(pp.getIndex());
                return n;
            }
            if (n instanceof BigDecimal) {
                try {
                    BigInteger b = ((BigDecimal)n).toBigIntegerExact();
                    parsePosition.setIndex(pp.getIndex());
                    return b;
                }
                catch (ArithmeticException b) {}
            } else if (n instanceof Long) {
                long v = n.longValue();
                parsePosition.setIndex(pp.getIndex());
                return new BigDecimal(v).toBigInteger();
            }
            parsePosition.setErrorIndex(parsePosition.getIndex());
        } else {
            parsePosition.setErrorIndex(pp.getIndex());
        }
        return null;
    }

    public Object clone() {
        return new ToBigIntegerFormat(this, false);
    }
}

