/*
 * Decompiled with CFR 0.152.
 */
package woolpack.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import woolpack.dom.DomContext;
import woolpack.test.TestUtils;
import woolpack.utils.NodeFindableFactory;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDomContextBuilder {
    public static final Iterable<String> ATTR_NAMES = Collections.singleton("id");
    private final Iterable<String> attrNames;
    private final Map<String, List<String>> input;
    private final DomContext context;
    private final NodeFindableFactory factory;

    public TestDomContextBuilder(Iterable<String> attrNames, NodeFindableFactory factory) {
        attrNames.getClass();
        factory.getClass();
        this.attrNames = attrNames;
        this.factory = factory;
        this.input = new HashMap<String, List<String>>();
        this.context = new DomContext();
        this.context.setConfig(new HashMap<String, Object>());
        this.context.setInput(this.input);
        this.context.setRequest(new HashMap<String, Object>());
        this.context.setSession(UtilsConstants.concurrentMap(new HashMap(), new Object()));
        this.context.setApplication(UtilsConstants.concurrentMap(new HashMap(), new Object()));
    }

    public TestDomContextBuilder(NodeFindableFactory factory) {
        this(ATTR_NAMES, factory);
    }

    public void init() {
        this.context.getInput().clear();
        this.context.getRequest().clear();
        this.context.setNode(null);
    }

    public void initXPath(String criteria) {
        this.context.getInput().clear();
        Node n = this.factory.newInstance(criteria).evaluateOne(this.context.getNode());
        if (n != null && n.getNodeType() == 1) {
            Element e = (Element)n;
            if (e.getNodeName().equals("FORM")) {
                this.input.putAll(TestUtils.selectForm(e));
                this.context.setId(e.getAttribute("action"));
            } else if (e.getNodeName().equals("A")) {
                String href = e.getAttribute("href");
                this.input.putAll(TestUtils.selectQuery(href));
                this.context.setId(href.substring(0, href.indexOf(63) >= 0 ? href.indexOf(63) : href.length()));
            }
        }
        this.context.getRequest().clear();
        this.context.setNode(null);
    }

    public Map<String, List<String>> getInput() {
        return this.input;
    }

    public DomContext get() {
        return this.context;
    }

    public void print() {
        TestUtils.print(this.context);
    }

    public boolean exists(String criteria) {
        return this.selectNode(criteria) != null;
    }

    public Node selectNode(String criteria) {
        return this.factory.newInstance(criteria).evaluateOne(this.context.getNode());
    }

    public Map<String, List<String>> selectEmbedded() {
        return TestUtils.selectEmbedded(this.attrNames, this.context.getNode());
    }
}

