/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el.convert;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import woolpack.el.convert.CollectionConverter;
import woolpack.el.convert.Convertable;
import woolpack.el.convert.DelegationIfNecessityConverter;
import woolpack.el.convert.SerialConverter;
import woolpack.el.convert.SimpleConverter;
import woolpack.el.convert.ToTypeToWapperConverter;
import woolpack.el.convert.ValidatorConverter;
import woolpack.text.BooleanFormat;
import woolpack.validator.ValidatorExpression;

public class ConvertConstants {
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final BooleanFormat BOOLEAN_FORMAT = new BooleanFormat();
    public static final Convertable ECHO = new Convertable(){

        public Object convert(Object beforeValue, Class toType, String propertyName) {
            return beforeValue;
        }
    };
    public static final Convertable SIMPLE_CONVERTER = ConvertConstants.getSimpleConverter(NUMBER_FORMAT, DATE_FORMAT, BOOLEAN_FORMAT);
    public static final Convertable COLLECTION_CONVERTER = ConvertConstants.getCollectionConverter(NUMBER_FORMAT, DATE_FORMAT, BOOLEAN_FORMAT);

    private ConvertConstants() {
    }

    public static Convertable getSimpleConverter(NumberFormat numberFormat, DateFormat dateFormat, BooleanFormat booleanFormat) {
        return new DelegationIfNecessityConverter(new ToTypeToWapperConverter(new SimpleConverter(numberFormat, dateFormat, booleanFormat)));
    }

    public static Convertable getSimpleConverter(ValidatorExpression expression, NumberFormat numberFormat, DateFormat dateFormat, BooleanFormat booleanFormat) {
        return new DelegationIfNecessityConverter(new SerialConverter(new ValidatorConverter(expression), new ToTypeToWapperConverter(new SimpleConverter(numberFormat, dateFormat, booleanFormat))));
    }

    public static Convertable getCollectionConverter(NumberFormat numberFormat, DateFormat dateFormat, BooleanFormat booleanFormat) {
        return new DelegationIfNecessityConverter(new CollectionConverter(ConvertConstants.getSimpleConverter(numberFormat, dateFormat, booleanFormat)));
    }

    public static Convertable getCollectionConverter(ValidatorExpression expression, NumberFormat numberFormat, DateFormat dateFormat, BooleanFormat booleanFormat) {
        return new DelegationIfNecessityConverter(new CollectionConverter(ConvertConstants.getSimpleConverter(expression, numberFormat, dateFormat, booleanFormat)));
    }
}

