/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Element;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Serial;
import woolpack.dom.XPath;
import woolpack.utils.NodeFindable;
import woolpack.utils.NodeFindableFactory;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionBuilder {
    public static final String KEY = "woolpack.transaction.TRANSACTION_TOKEN";
    private final String key;
    private final Random r;
    private final Collection<String> idCollection;
    private final int size;
    private final NodeFindable xpathForm;
    private final NodeFindable xpathHref;

    public TransactionBuilder(String key, Collection<String> idCollection, int size, NodeFindableFactory factory) {
        key.charAt(0);
        idCollection.getClass();
        this.key = key;
        this.r = new Random();
        this.idCollection = idCollection;
        this.size = size;
        this.xpathForm = factory.newInstance("//FORM");
        this.xpathHref = factory.newInstance("//A[@href]");
    }

    public TransactionBuilder(Collection<String> idCollection, NodeFindableFactory factory) {
        this(KEY, idCollection, 32, factory);
    }

    public String getKey() {
        return this.key;
    }

    String generateToken() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.size) {
            int j = this.r.nextInt(36);
            sb.append(j < 10 ? (char)(48 + j) : (char)(65 + j - 10));
            ++i;
        }
        return sb.toString();
    }

    public DomExpression getCheckExpression(final DomExpression trueExpression, final DomExpression falseExpression) {
        trueExpression.getClass();
        falseExpression.getClass();
        return new DomExpression(){

            public void interpret(DomContext context) {
                if (TransactionBuilder.this.idCollection.contains(context.getId())) {
                    Object oldToken = context.getSession().get(TransactionBuilder.this.key);
                    List requestedTokens = UtilsConstants.toList(context.getInput().get(TransactionBuilder.this.key));
                    String newToken = TransactionBuilder.this.generateToken();
                    if (oldToken != null && oldToken.equals(requestedTokens.get(0)) && context.getSession().replace(TransactionBuilder.this.key, oldToken, newToken)) {
                        trueExpression.interpret(context);
                    } else {
                        falseExpression.interpret(context);
                    }
                } else {
                    String newToken;
                    Object oldToken;
                    do {
                        oldToken = context.getSession().get(TransactionBuilder.this.key);
                        newToken = TransactionBuilder.this.generateToken();
                    } while (!(oldToken == null ? context.getSession().putIfAbsent(TransactionBuilder.this.key, newToken) == null : context.getSession().replace(TransactionBuilder.this.key, oldToken, newToken)));
                    trueExpression.interpret(context);
                }
            }
        };
    }

    public DomExpression getAppendExpression() {
        return new Serial(new XPath(this.xpathForm, new DomExpression(){

            public void interpret(DomContext context) {
                String token = (String)context.getSession().get(TransactionBuilder.this.key);
                if (token != null) {
                    Element element = DomConstants.getDocumentNode(context.getNode()).createElement("INPUT");
                    element.setAttribute("type", "hidden");
                    element.setAttribute("name", TransactionBuilder.this.key);
                    element.setAttribute("value", token);
                    context.getNode().appendChild(element);
                }
            }
        }), new XPath(this.xpathHref, new DomExpression(){

            public void interpret(DomContext context) {
                String token = (String)context.getSession().get(TransactionBuilder.this.key);
                if (token != null) {
                    Element element = (Element)context.getNode();
                    String href = element.getAttribute("href");
                    String newHref = String.valueOf(href) + (href.indexOf(63) >= 0 ? (char)'&' : '?') + TransactionBuilder.this.key + "=" + token;
                    element.setAttribute("href", newHref);
                }
            }
        }));
    }

    public Collection<String> getIdCollection() {
        return Collections.unmodifiableCollection(this.idCollection);
    }
}

