/*
 * Decompiled with CFR 0.152.
 */
package woolpack.ee;

import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.Switchable;
import woolpack.utils.concurrent.Acquirable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoAcquireTransaction
implements DomExpression {
    public static final String KEY = "woolpack.ee.TRY_SEMAPHORE_TRANSACTION";
    private final String key;
    private final Switchable<String, Acquirable> startIdSwitchable;
    private final Collection<String> midIdCollection;
    private final Collection<String> endIdCollection;
    private final DomExpression trueExpression;
    private final DomExpression falseExpression;
    private final DomExpression releaseExpression;

    public DoAcquireTransaction(String key, Switchable<String, Acquirable> startIdSwitchable, Collection<String> midIdCollection, Collection<String> endIdCollection, DomExpression trueExpression, DomExpression falseExpression, DomExpression releaseExpression) {
        key.charAt(0);
        startIdSwitchable.getClass();
        midIdCollection.getClass();
        endIdCollection.getClass();
        trueExpression.getClass();
        falseExpression.getClass();
        releaseExpression.getClass();
        DoAcquireTransaction.checkDuplicate(startIdSwitchable.keys(), midIdCollection);
        DoAcquireTransaction.checkDuplicate(startIdSwitchable.keys(), endIdCollection);
        DoAcquireTransaction.checkDuplicate(midIdCollection, endIdCollection);
        this.key = key;
        this.startIdSwitchable = startIdSwitchable;
        this.midIdCollection = midIdCollection;
        this.endIdCollection = endIdCollection;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
        this.releaseExpression = releaseExpression;
    }

    private static void checkDuplicate(Collection<String> set0, Collection<String> set1) {
        HashSet<String> set = new HashSet<String>(set0);
        set.retainAll(set1);
        if (!set.isEmpty()) {
            throw new IllegalArgumentException("duplicate id: " + set);
        }
    }

    public DoAcquireTransaction(Switchable<String, Acquirable> startIdSwitchable, Collection<String> midIdCollection, Collection<String> endIdCollection, DomExpression trueExpression, DomExpression falseExpression, DomExpression releaseExpression) {
        this(KEY, startIdSwitchable, midIdCollection, endIdCollection, trueExpression, falseExpression, releaseExpression);
    }

    public DoAcquireTransaction(Switchable<String, Acquirable> startIdSwitchable, Collection<String> midIdCollection, Collection<String> endIdCollection, DomExpression trueExpression, DomExpression falseExpression) {
        this(startIdSwitchable, midIdCollection, endIdCollection, trueExpression, falseExpression, DomConstants.NULL);
    }

    private void release(DomContext context) {
        try {
            this.releaseExpression.interpret(context);
        }
        finally {
            context.getSession().remove(this.key);
        }
    }

    @Override
    public void interpret(DomContext context) {
        final Acquirable acquirable = this.startIdSwitchable.get(context.getId());
        if (acquirable != null) {
            if (context.getSession().containsKey(this.key)) {
                this.release(context);
            }
            if (acquirable.acquire()) {
                context.getSession().put(this.key, new HttpSessionBindingListener(){

                    public void valueBound(HttpSessionBindingEvent arg0) {
                    }

                    public void valueUnbound(HttpSessionBindingEvent arg0) {
                        acquirable.release();
                    }
                });
                try {
                    this.trueExpression.interpret(context);
                }
                catch (RuntimeException e) {
                    this.release(context);
                    throw e;
                }
            } else {
                this.falseExpression.interpret(context);
            }
        } else if (this.midIdCollection.contains(context.getId())) {
            if (context.getSession().containsKey(this.key)) {
                try {
                    this.trueExpression.interpret(context);
                }
                catch (RuntimeException e) {
                    this.release(context);
                    throw e;
                }
            } else {
                this.falseExpression.interpret(context);
            }
        } else if (this.endIdCollection.contains(context.getId())) {
            if (context.getSession().containsKey(this.key)) {
                try {
                    this.trueExpression.interpret(context);
                }
                finally {
                    this.release(context);
                }
            } else {
                this.falseExpression.interpret(context);
            }
        } else {
            if (context.getSession().containsKey(this.key)) {
                this.release(context);
            }
            this.trueExpression.interpret(context);
        }
    }
}

