/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.io.IOException;

import woolpack.test.TestUtils;

import junit.framework.TestCase;

public class StringReaderFactoryTest extends TestCase {


	public void testConstructor(){
		try{
			new StringReaderFactory(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal() throws IOException{
		final ReaderFactory factory = new StringReaderFactory("hoge");
		assertEquals("hoge", TestUtils.toString(factory.newInstance(null)));
	}
}
