/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import junit.framework.TestCase;

public class TrysDateFormatTest extends TestCase {

	public void testConstructor(){
		try{
			new TrysDateFormat((Iterable<DateFormat>)null);
			fail();
		}catch(final NullPointerException e){
		}
		try{
			new TrysDateFormat((DateFormat[])null);
			fail();
		}catch(final NullPointerException e){
		}
	}
	
	private void scenario(final Format format) throws ParseException{
		final Date date0 = new SimpleDateFormat("yyyyMMddHHmmss").parse("20060601123157");
		final Date date1 = new SimpleDateFormat("yyyyMMdd").parse("20060601");
		assertEquals("20060601123157", format.format(date0));
		assertEquals("20060601000000", format.format(date1));
		assertEquals(date0, format.parseObject("20060601123157"));
		assertEquals(date1, format.parseObject("20060601"));
		try{
			format.parseObject("a2006060");
			fail();
		}catch(final ParseException e){
		}
	}

	public void testNormal() throws ParseException{
		final Format format0 = new TrysDateFormat(
				new SimpleDateFormat("yyyyMMddHHmmss"),
				new SimpleDateFormat("yyyyMMdd"));
		scenario(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario(format1);
	}
}
