/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.io.IOException;
import java.util.Locale;

import junit.framework.TestCase;
import woolpack.test.TestUtils;
import woolpack.utils.FixSwitch;
import woolpack.utils.ReaderFactory;
import woolpack.utils.StringReaderFactory;
import woolpack.utils.SwitchBuilder;

public class LocaleReaderFactoryTest extends TestCase {

	public void testConstructor(){
		try{
			new LocaleReaderFactory(null, new ThreadLocal<Locale>());
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new LocaleReaderFactory(new FixSwitch<Locale,ReaderFactory>(null), null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal() throws IOException{
		final ThreadLocal<Locale> threadLocal = new ThreadLocal<Locale>();
		final ReaderFactory factory = new LocaleReaderFactory(
				new SwitchBuilder<Locale,ReaderFactory>()
				.put(Locale.JAPANESE, new StringReaderFactory("j"))
				.put(Locale.ENGLISH, new StringReaderFactory("e"))
				.get(new StringReaderFactory("n")), threadLocal);
		
		threadLocal.set(Locale.JAPANESE);
		assertEquals("j", TestUtils.toString(factory.newInstance(null)));

		threadLocal.set(Locale.ENGLISH);
		assertEquals("e", TestUtils.toString(factory.newInstance(null)));

		threadLocal.set(Locale.CHINESE);
		assertEquals("n", TestUtils.toString(factory.newInstance(null)));
	}
}
