/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class HtmlAllTests extends TestCase {

	public static Test suite() {
		TestSuite suite = new TestSuite();

		suite.addTest(new TestSuite(AutoUpdateTest.class));
		suite.addTest(new TestSuite(BranchPropertyCountTest.class));
		suite.addTest(new TestSuite(FrameToTableTest.class));
		suite.addTest(new TestSuite(HiddenAllToChildTest.class));
		suite.addTest(new TestSuite(HtmlConstantsTest.class));
		suite.addTest(new TestSuite(MakeRadioTest.class));
		suite.addTest(new TestSuite(MakeSelectTest.class));
		suite.addTest(new TestSuite(PropertyCounterTest.class));
		suite.addTest(new TestSuite(UpdateToSelectedValueTest.class));
		suite.addTest(new TestSuite(UpdateValueTest.class));
		suite.addTest(new TestSuite(UpdateValue2Test.class));
		
		return suite;
	}
}
