/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

import woolpack.utils.MapBuilder;
import woolpack.utils.UtilsConstants;

import junit.framework.TestCase;

public class SaveInputForBackTest extends TestCase {

	public void testConstractor(){
		try{
			new SaveInputForBack(null, DomConstants.NULL, new HashMap<String,String>(), new HashMap<String,String>());
			fail();
		}catch(final NullPointerException e){
		}
		try{
			new SaveInputForBack("", DomConstants.NULL, new HashMap<String,String>(), new HashMap<String,String>());
			fail();
		}catch(final StringIndexOutOfBoundsException e){
		}
		try{
			new SaveInputForBack("key0", null, new HashMap<String,String>(), new HashMap<String,String>());
			fail();
		}catch(final NullPointerException e){
		}
		try{
			new SaveInputForBack("key0", DomConstants.NULL, null, new HashMap<String,String>());
			fail();
		}catch(final NullPointerException e){
		}
		try{
			new SaveInputForBack("key0", DomConstants.NULL, new HashMap<String,String>(), null);
			fail();
		}catch(final NullPointerException e){
		}
	}
	
	private void scenario(final DomExpression expression, final ConcurrentMap<String,Object> session){
		// 一覧検索条件入力画面に遷移。その実行前にセッションに保存した検索条件で入力値を置き換え。
		{
			final Map map = new HashMap();
			final DomContext context = new DomContext();
			context.setSession(session);
			context.setInput(map);
			context.setId("a_list_input_back");
			expression.interpret(context);
			assertEquals("a_list_input", context.getId());
			assertSame(map, context.getInput());
		}
		// 一覧検索条件入力画面に遷移し
		{
			final Map map = new HashMap();
			final DomContext context = new DomContext();
			context.setSession(session);
			context.setInput(map);
			context.setId("a_list_input");
			expression.interpret(context);
			assertEquals("a_list_input", context.getId());
			assertSame(map, context.getInput());
		}
		// 検索実行し検索結果一覧画面に遷移。その際検索条件をセッションに保存。
		final Map map_a_list_result0 = new HashMap();
		{
			final DomContext context = new DomContext();
			context.setSession(session);
			context.setInput(map_a_list_result0);
			context.setId("a_list_result");
			expression.interpret(context);
			assertEquals("a_list_result", context.getId());
			assertSame(map_a_list_result0, context.getInput());
		}
		// 一覧検索条件入力画面に遷移。その実行前にセッションに保存した検索条件で入力値を置き換え。
		{
			final Map map = new HashMap();
			final DomContext context = new DomContext();
			context.setSession(session);
			context.setInput(map);
			context.setId("a_list_input_back");
			expression.interpret(context);
			assertEquals("a_list_input", context.getId());
			assertSame(map_a_list_result0, context.getInput());
		}
		// 検索実行し検索結果一覧画面に遷移。その際検索条件をセッションに保存。
		final Map map_a_list_result1 = new HashMap();
		{
			final DomContext context = new DomContext();
			context.setSession(session);
			context.setInput(map_a_list_result1);
			context.setId("a_list_result");
			expression.interpret(context);
			assertEquals("a_list_result", context.getId());
			assertSame(map_a_list_result1, context.getInput());
		}
		// 検索結果一覧からひとつ選んで詳細入力が面に遷移。
		{
			final Map map = new HashMap();
			final DomContext context = new DomContext();
			context.setSession(session);
			context.setInput(map);
			context.setId("a_detail_input");
			expression.interpret(context);
			assertEquals("a_detail_input", context.getId());
			assertSame(map, context.getInput());
		}
		// 検索実行し検索結果一覧画面に遷移。その実行前にセッションに保存した検索条件で入力値を置き換え。
		{
			final Map map = new HashMap();
			final DomContext context = new DomContext();
			context.setSession(session);
			context.setInput(map);
			context.setId("a_list_result_back");
			expression.interpret(context);
			assertEquals("a_list_result", context.getId());
			assertSame(map_a_list_result1, context.getInput());
		}
		// 一覧検索条件入力画面に遷移。その実行前にセッションに保存した検索条件で入力値を置き換え。
		{
			final Map map = new HashMap();
			final DomContext context = new DomContext();
			context.setSession(session);
			context.setInput(map);
			context.setId("a_list_input_back");
			expression.interpret(context);
			assertEquals("a_list_input", context.getId());
			assertSame(map_a_list_result1, context.getInput());
		}
	}
	
	public void testNormal(){
		final DomExpression expression = new SaveInputForBack(DomConstants.NULL, 
				MapBuilder.get(new HashMap<String,String>())
				.put("a_list_input_back", "a_list_input")
				.put("a_list_result_back", "a_list_result")
				.get(),
				MapBuilder.get(new HashMap<String,String>())
				.put("a_list_input_back", "a_list_result")
				.put("a_list_result_back", "a_list_result")
				.get());
		scenario(expression, UtilsConstants.concurrentMap(new HashMap<String,Object>(), new Object()));
		scenario(expression, UtilsConstants.concurrentMap(new HashMap<String,Object>(), new Object()));
	}
}
