/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import junit.framework.TestCase;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.IOExceptionReaderFactory;
import woolpack.utils.NullReaderFactory;
import woolpack.utils.StringReaderFactory;
import woolpack.utils.UtilsConstants;

public class ToNodeUsingNekoTest extends TestCase {
	
	public void testNormal(){
		final DomExpression expression = new ToNodeUsingNeko(new StringReaderFactory("<HTML><BODY>neko</BODY></HTML>"));
		final DomContext context = new DomContext();
		expression.interpret(context);
		final Writer w = new StringWriter();
		UtilsConstants.TRANSFORMER_FACTORY.newInstance().transform(
				new DOMSource(context.getNode()), 
				new StreamResult(w)
		);
		assertTrue(w.toString().indexOf("neko") >= 0);
	}
	
	public void testIOException(){
		final DomExpression expression = new ToNodeUsingNeko(new IOExceptionReaderFactory());
		final DomContext context = new DomContext();
		try{
			expression.interpret(context);
			fail();
		}catch(final RuntimeException expected){
			assertTrue(expected.getCause() instanceof IOException);
		}
	}
	
	public void testNull(){
		final DomExpression expression = new ToNodeUsingNeko(new NullReaderFactory());
		final DomContext context = new DomContext();
		try{
			expression.interpret(context);
			fail();
		}catch(final RuntimeException expected){
			assertTrue(expected.getCause() instanceof FileNotFoundException);
		}
	}
}
