/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import woolpack.action.ActionAllTests;
import woolpack.adapter.AdapterAllTests;
import woolpack.config.ConfigAllTests;
import woolpack.container.ContainerAllTests;
import woolpack.dom.DomAllTests;
import woolpack.ee.EEAllTests;
import woolpack.el.ElAllTests;
import woolpack.el.convert.ConvertAllTests;
import woolpack.html.HtmlAllTests;
import woolpack.locale.LocaleAllTests;
import woolpack.test.TestAllTests;
import woolpack.text.TextAllTests;
import woolpack.utils.UtilsAllTests;
import woolpack.utils.concurrent.ConcurrentAllTests;
import woolpack.validator.ValidatorAllTests;
import woolpack.visitor.VisitorAllTests;
import woolpack.visitor.impl.VisitorImplAllTests;

public class AllTests extends TestCase {
	public static Test suite() {
		final TestSuite suite = new TestSuite();
		suite.addTest(ActionAllTests.suite());
		suite.addTest(AdapterAllTests.suite());
		suite.addTest(ConfigAllTests.suite());
		suite.addTest(ContainerAllTests.suite());
		suite.addTest(DomAllTests.suite());
		suite.addTest(EEAllTests.suite());
		suite.addTest(ElAllTests.suite());
		suite.addTest(ConvertAllTests.suite());
		suite.addTest(HtmlAllTests.suite());
		suite.addTest(LocaleAllTests.suite());
		suite.addTest(TestAllTests.suite());
		suite.addTest(TextAllTests.suite());
		suite.addTest(UtilsAllTests.suite());
		suite.addTest(ConcurrentAllTests.suite());
		suite.addTest(ValidatorAllTests.suite());
		suite.addTest(VisitorAllTests.suite());
		suite.addTest(VisitorImplAllTests.suite());
		return suite;
	}
	
	public static void main(String[] args){
		junit.textui.TestRunner.run(suite());
	}
}
