/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

/**
 * {@link javax.xml.transform}の恒等変換をラップした{@link XmlTransformerFactory}。
 * このクラスとこのクラスが生成する{@link XmlTransformer}は同時に動作する複数のスレッドで使用することができない。
 * 適用しているパターン：Adapter。
 * @author nakamura
 *
 */
public class XmlTransformerFactoryImpl implements XmlTransformerFactory{
	private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

	public XmlTransformer newInstance() {
		final Transformer transformer;
		try {
			transformer = transformerFactory.newTransformer();
		} catch (final TransformerConfigurationException e) {
			throw new RuntimeException(e);// カバレージがここを通過してはいけない
		}
		
		/**
		 * @throws RuntimeException ({@link javax.xml.transform.TransformerException})DOM ノードの生成に失敗した場合。
		 */
		return new XmlTransformer(){
			public void transform(final Source xmlSource, final Result outputTarget) {
				try {
					transformer.transform(xmlSource, outputTarget);
				} catch (final TransformerException e) {
					throw new RuntimeException(e);
				}
			}
		};
	}
}
