/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.util.HashMap;

import woolpack.utils.MapBuilder;

/**
 * 真偽値をフォーマットする変換器。
 * @author nakamura
 *
 */
public class BooleanFormat extends LimitedValueFormat {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * コピーコンストラクタ。
	 * {@link #clone()}から呼び出される(called)。
	 * @param format コピー元。
	 */
	protected BooleanFormat(final BooleanFormat format){
		super(format);
	}
	
	/**
	 * コンストラクタ。
	 * @param trueString true 値の文字列表現。
	 * @param falseString false 値の文字列表現。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 * @throws StringIndexOutOfBoundsException replacement が空の場合。
	 */
	public BooleanFormat(final String trueString, final String falseString){
		super(MapBuilder.get(new HashMap<String,Boolean>()).put(trueString,Boolean.TRUE).get(), Boolean.FALSE, falseString);
		trueString.charAt(0);
		falseString.charAt(0);
	}
	
	/**
	 * コンストラクタ。
	 * true 値の文字列表現として"true"を使用する。
	 * false 値の文字列表現として"false"を使用する。
	 */
	public BooleanFormat(){
		this("true", "false");
	}

	@Override public Object clone(){
		return new BooleanFormat(this);
	}
}
