/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.test;

import java.util.Map;

import woolpack.container.ComponentDef;
import woolpack.container.ScopeContainer;
import woolpack.dom.DomContext;
import woolpack.utils.NodeFindableFactory;

/**
 * テスト用の{@link DomContext}のビルダ。
 * @author nakamura
 *
 */
public class TestDomContextBuilder2 extends TestDomContextBuilder {
	
	/**
	 * コンストラクタ。
	 * @param attrNames {@link #selectEmbedded()}内で DOM ノードを検索するための属性名一覧。 
	 * @param factory {@link woolpack.utils.NodeFindable}のファクトリ。
	 * @param componentDefMap コンポーネント定義。
	 * @throws NullPointerException 引数のいずれかがが null の場合。
	 */
	public TestDomContextBuilder2(
			final Iterable<String> attrNames, 
			final NodeFindableFactory factory, 
			final Map<String,ComponentDef> componentDefMap){
		super(attrNames, factory);
		get().setContainer(new ScopeContainer(get().getRequest(), get().getSession(), get().getApplication(), componentDefMap));
	}

	/**
	 * コンストラクタ。
	 * @param componentDefMap コンポーネント定義。 
	 * @param factory {@link woolpack.utils.NodeFindable}のファクトリ。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public TestDomContextBuilder2(final NodeFindableFactory factory, final Map<String,ComponentDef> componentDefMap){
		this(TestDomContextBuilder.ATTR_NAMES, factory, componentDefMap);
	}
}
