/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * 委譲先のエラーを{@link ELTargetRuntimeException}でラップする{@link EL}。
 * 式言語として Java を使用する場合に使用する。
 * 適用しているパターン：Proxy, Template Method。
 * @author nakamura
 *
 */
abstract public class ToELTargetExceptionEL<V> extends ELAdapter {

	@Override public void setValue(final Object root, final Object value)
			throws ELTargetRuntimeException {
		executePrivate(root, value);
	}

	@Override public Object getValue(final Object root, final Class clazz)
			throws ELTargetRuntimeException {
		return executePrivate(root, clazz);
	}
	
	private Object executePrivate(final Object root, final Object value)throws ELTargetRuntimeException {
		final V root2 = (V)root;
		try{
			return execute(root2, value);
		}catch(final ELTargetRuntimeException e){
			throw e;
		}catch(final Exception e){
			throw new ELTargetRuntimeException(e);
		}
	}
	
	/**
	 * {@link #setValue(Object, Object)}または{@link #getValue(Object, Class)}から呼び出される(called)。
	 * @param root 基点。
	 * @param value 値。
	 * @return 返却値。
	 * @throws Exception 呼び出し元はここで投げられた例外を{@link ELTargetRuntimeException}でラップして呼出元へ投げる。
	 */
	abstract public Object execute(final V root, final Object value) throws Exception;
}
