/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

/**
 * 委譲の前後でスリープする{@link DomExpression}。
 * テスト用。
 * 適用しているパターン：Proxy。
 * @author nakamura
 *
 */
public class Sleep implements DomExpression {
	private final long beforeMillis;
	private final long afterMillis;
	private final DomExpression expression;
	
	/**
	 * コンストラクタ。
	 * @param beforeMillis 委譲前のスリープ時間(ミリ秒単位)。
	 * @param afterMillis 委譲後のスリープ時間(ミリ秒単位)。
	 * @param expression 委譲先。
	 * @throws NullPointerException expression が null の場合。
	 */
	public Sleep(final long beforeMillis, final long afterMillis, final DomExpression expression){
		expression.getClass();
		
		this.beforeMillis = beforeMillis;
		this.afterMillis = afterMillis;
		this.expression = expression;
	}

	public void interpret(final DomContext context) {
		if(beforeMillis > 0){
			try{
				Thread.sleep(beforeMillis);
			}catch(final InterruptedException e){
				Thread.currentThread().interrupt();
				throw new RuntimeException(e);
			}
		}
		expression.interpret(context);
		if(afterMillis > 0){
			try{
				Thread.sleep(afterMillis);
			}catch(final InterruptedException e){
				Thread.currentThread().interrupt();
				throw new RuntimeException(e);
			}
		}
	}
}
