/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.adapter;

import java.lang.reflect.Member;
import java.util.Map;

import ognl.TypeConverter;
import woolpack.el.convert.Convertable;

/**
 * {@link Convertable}に委譲する{@link TypeConverter}。
 * 適用しているパターン：Adapter。
 * @author nakamura
 *
 */
public class ConvertableTypeConverter implements TypeConverter {
	private final Convertable convertable;
	
	/**
	 * コンストラクタ。
	 * @param convertable 委譲先。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public ConvertableTypeConverter(final Convertable convertable){
		convertable.getClass();
		this.convertable = convertable;
	}

	public Object convertValue(
			final Map context, 
			final Object target, 
			final Member member, 
			final String propertyName, 
			final Object beforeValue, 
			final Class toType) {
		return convertable.convert(beforeValue, toType, propertyName);
	}
}
