/*
 * Decompiled with CFR 0.152.
 */
package woolpack.visitor.impl;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import woolpack.locale.BranchByLocaleValidator;
import woolpack.text.DelegateDateFormat;
import woolpack.text.DelegateNumberFormat;
import woolpack.text.FormatFactory;
import woolpack.text.LimitedValueFormat;
import woolpack.text.RegExpFormat;
import woolpack.text.ToCharacterFormat;
import woolpack.text.ToStringFormat;
import woolpack.utils.MapBuilder;
import woolpack.utils.Switchable;
import woolpack.validator.CountValidator;
import woolpack.validator.DelegationValidator;
import woolpack.validator.DumpValidator;
import woolpack.validator.IfNotValidator;
import woolpack.validator.IfValidator;
import woolpack.validator.ValidatorConstants;
import woolpack.validator.ValidatorExpression;
import woolpack.visitor.Acceptable;
import woolpack.visitor.JsVisitorConstants;
import woolpack.visitor.Visitor;
import woolpack.visitor.impl.IgnoreTextConstants;
import woolpack.visitor.impl.IgnoreValidatorConstants;

public class JsConstants {
    public static final Acceptable<BranchByLocaleValidator> ACCEPT_BranchByLocaleValidator = JsVisitorConstants.classNameAcceptable(new Acceptable<BranchByLocaleValidator>(){

        @Override
        public void accept(Visitor visitor, BranchByLocaleValidator v) {
            visitor.visit(v.getSwitchable());
        }
    });
    public static final Acceptable<IfNotValidator> ACCEPT_IfNotValidator = new Acceptable<IfNotValidator>(){

        @Override
        public void accept(Visitor visitor, IfNotValidator v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append("new IfNotValidator(");
            visitor.visit(v.getIfExpression());
            sb.append(',');
            visitor.visit(v.getFalseExpression());
            sb.append(')');
        }
    };
    public static final Acceptable<IfValidator> ACCEPT_IfValidator = new Acceptable<IfValidator>(){

        @Override
        public void accept(Visitor visitor, IfValidator v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append("new IfValidator(");
            visitor.visit(v.getIfExpression());
            sb.append(',');
            visitor.visit(v.getTrueExpression());
            sb.append(',');
            visitor.visit(v.getFalseExpression());
            sb.append(')');
        }
    };
    public static final Acceptable<SimpleDateFormat> ACCEPT_SimpleDateFormat = new Acceptable<SimpleDateFormat>(){

        @Override
        public void accept(Visitor visitor, SimpleDateFormat v) {
            StringBuilder sb = (StringBuilder)visitor.getContext();
            sb.append("new SimpleDateFormat(");
            visitor.visit(v.toPattern());
            sb.append(')');
        }
    };
    public static final Map<Object, Acceptable> BASE = Collections.unmodifiableMap(MapBuilder.get(new LinkedHashMap()).put(ValidatorConstants.TRUE, JsVisitorConstants.objectAcceptable("new TrueValidator()")).put(ValidatorConstants.FALSE, JsVisitorConstants.objectAcceptable("new FalseValidator()")).put(ValidatorConstants.REQUIRED, JsVisitorConstants.objectAcceptable("new RequiredValidator()")).put((ValidatorExpression)((Object)ValidatorConstants.OR), JsVisitorConstants.objectAcceptable("new OrValidatorIterable()")).put((ValidatorExpression)((Object)ValidatorConstants.OROR), JsVisitorConstants.objectAcceptable("new OrOrValidatorIterable()")).put((ValidatorExpression)((Object)ValidatorConstants.AND), JsVisitorConstants.objectAcceptable("new AndValidatorIterable()")).put((ValidatorExpression)((Object)ValidatorConstants.ANDAND), JsVisitorConstants.objectAcceptable("new AndAndValidatorIterable()")).put((ValidatorExpression)((Object)ValidatorConstants.EQ), JsVisitorConstants.objectAcceptable("new EqValidatorIterable()")).put((ValidatorExpression)((Object)ValidatorConstants.EQEQ), JsVisitorConstants.objectAcceptable("new EqEqValidatorIterable()")).put((ValidatorExpression)((Object)CountValidator.class), (Acceptable<Acceptable<CountValidator>>)IgnoreValidatorConstants.IGNORE_CountValidator).put(DumpValidator.class, IgnoreValidatorConstants.IGNORE_DumpValidator).put(BranchByLocaleValidator.class, ACCEPT_BranchByLocaleValidator).put(IfNotValidator.class, ACCEPT_IfNotValidator).put(IfValidator.class, ACCEPT_IfValidator).put(ValidatorExpression.class, JsVisitorConstants.classNameAcceptable(JsVisitorConstants.PARAMS)).get());
    public static final Map<Object, Acceptable> MAP = Collections.unmodifiableMap(MapBuilder.get(new LinkedHashMap()).putAll(BASE).put(DelegationValidator.class, IgnoreValidatorConstants.IGNORE_DelegationValidator).put(Iterable.class, JsVisitorConstants.ITERABLE).put(Switchable.class, JsVisitorConstants.switchableAcceptable(null)).put(Map.class, JsVisitorConstants.MAP).put(FormatFactory.class, IgnoreTextConstants.IGNORE_FormatFactory).put(LimitedValueFormat.class, JsVisitorConstants.classNameAcceptable(JsVisitorConstants.PARAMS)).put(RegExpFormat.class, JsVisitorConstants.classNameAcceptable(JsVisitorConstants.PARAMS)).put(ToCharacterFormat.class, JsVisitorConstants.objectAcceptable("new ToCharacterFormat()")).put(ToStringFormat.class, JsVisitorConstants.objectAcceptable("new ToStringFormat()")).put(DelegateNumberFormat.class, IgnoreTextConstants.IGNORE_DelegateNumberFormat).put(DecimalFormat.class, JsVisitorConstants.objectAcceptable("new DecimalFormat()")).put(DelegateDateFormat.class, IgnoreTextConstants.IGNORE_DelegateDateFormat).put(SimpleDateFormat.class, ACCEPT_SimpleDateFormat).put(DateFormat.class, JsVisitorConstants.objectAcceptable("new SimpleDateFormat(\"yyyyMMdd\")")).put(String.class, JsVisitorConstants.escapeStringAcceptable(JsVisitorConstants.OBJECT)).put(Locale.class).put(Pattern.class).put(Object.class, JsVisitorConstants.OBJECT).get());

    private JsConstants() {
    }
}

