/*
 * Decompiled with CFR 0.152.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import woolpack.validator.MessageCollectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorContext {
    private String id;
    private Map<String, List<Object>> inputMap;
    private MessageCollectable collectable;
    private String tmpKey;
    private int tmpIndex;

    public ValidatorContext() {
    }

    public ValidatorContext(ValidatorContext base) {
        this.id = base.id;
        this.inputMap = base.inputMap;
        this.collectable = base.collectable;
        this.tmpKey = base.tmpKey;
        this.tmpIndex = base.tmpIndex;
    }

    public ValidatorContext copy() {
        return new ValidatorContext(this);
    }

    public void appendTo(Appendable sb) throws IOException {
        sb.append("ValidatorContext dump information:");
        ValidatorContext.appendTo(sb, "id", this.id);
        ValidatorContext.appendTo(sb, "inputMap", this.inputMap);
        ValidatorContext.appendTo(sb, "collectable", this.collectable);
        ValidatorContext.appendTo(sb, "tmpKey", this.tmpKey);
        ValidatorContext.appendTo(sb, "tmpIndex", this.tmpIndex);
    }

    private static void appendTo(Appendable sb, String label, Object o) throws IOException {
        sb.append('\n');
        sb.append(',');
        sb.append(label);
        sb.append(':');
        if (o != null) {
            sb.append(o.toString());
        }
    }

    public void add(String message) {
        this.collectable.add(message, this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, List<Object>> getInputMap() {
        return this.inputMap;
    }

    public void setInputMap(Map<String, List<Object>> inputMap) {
        this.inputMap = inputMap;
    }

    public String getTmpKey() {
        return this.tmpKey;
    }

    public void setTmpKey(String tmpKey) {
        this.tmpKey = tmpKey;
    }

    public int getTmpIndex() {
        return this.tmpIndex;
    }

    public void setTmpIndex(int tmpIndex) {
        this.tmpIndex = tmpIndex;
    }

    public Object getTmpValue() {
        List<Object> list = this.inputMap.get(this.tmpKey);
        if (list == null || list.size() <= this.tmpIndex) {
            return null;
        }
        return list.get(this.tmpIndex);
    }

    public void setTmpValue(Object value) {
        List<Object> list = this.inputMap.get(this.tmpKey);
        if (list == null) {
            list = new ArrayList<Object>();
            this.inputMap.put(this.tmpKey, list);
        }
        if (list.size() == 0 && this.tmpIndex == 0) {
            list.add(value);
        } else {
            list.set(this.tmpIndex, value);
        }
    }

    public MessageCollectable getCollectable() {
        return this.collectable;
    }

    public void setCollectable(MessageCollectable collectable) {
        this.collectable = collectable;
    }
}

