/*
 * Decompiled with CFR 0.152.
 */
package woolpack.utils;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import woolpack.utils.DelegationMap;
import woolpack.utils.InjectiveMap;
import woolpack.utils.KeyNotEmptyMap;
import woolpack.utils.NotNullMap;
import woolpack.utils.SimilarPropertyNameMap;
import woolpack.utils.Switchable;
import woolpack.utils.SynchronizedConcurrentMap;
import woolpack.utils.XmlTransformerFactory;
import woolpack.utils.XmlTransformerFactoryImpl;
import woolpack.utils.XmlTransformerFactorySemaphoreImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilsConstants {
    public static final XmlTransformerFactory TRANSFORMER_FACTORY = new XmlTransformerFactorySemaphoreImpl(new XmlTransformerFactoryImpl(), 5);
    public static final Set<Class> ATOM_SET = Collections.unmodifiableSet(new HashSet(Arrays.asList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, java.util.Date.class, Date.class, String.class, Number.class)));

    private UtilsConstants() {
    }

    public static <K, V> Switchable<K, V> nullToDefaultSwitchIfAbsent(final V defaultValue, final Switchable<K, V> switchable) {
        if (switchable.getDefault() != null) {
            return switchable;
        }
        return new Switchable<K, V>(){

            @Override
            public V get(K key) {
                Object v = switchable.get(key);
                if (v != null) {
                    return v;
                }
                return defaultValue;
            }

            @Override
            public Collection<K> keys() {
                return switchable.keys();
            }

            @Override
            public V getDefault() {
                return defaultValue;
            }
        };
    }

    public static <K, V> Map<V, K> inverseMap(Map<K, V> before) {
        HashMap after = new HashMap(before.size());
        Map<V, K> m = UtilsConstants.unoverwritableMap(after);
        for (K key : before.keySet()) {
            m.put(before.get(key), key);
        }
        return after;
    }

    public static <K, V> Map<K, V> injectiveMap(Map<K, V> map) {
        return new InjectiveMap<K, V>(map);
    }

    public static <K, V> Map<K, V> unoverwritableMap(Map<K, V> map) {
        map.getClass();
        return new DelegationMap<K, V>((Map)map){

            private void check(K key) {
                if (super.containsKey(key)) {
                    throw new IllegalStateException("already registered: " + key);
                }
            }

            @Override
            public V put(K key, V value) {
                this.check(key);
                return super.put(key, value);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> t) {
                for (Object key : t.keySet()) {
                    this.check(key);
                }
                super.putAll(t);
            }
        };
    }

    public static <K, V> Map<K, V> notNullMap(Map<K, V> map) {
        return new NotNullMap<K, V>(map);
    }

    public static <V> Map<String, V> keyNotEmptyMap(Map<String, V> map) {
        return new KeyNotEmptyMap<V>(map);
    }

    public static <V> Map<String, V> similarKeyMap(Map<String, V> map) {
        return new SimilarPropertyNameMap<V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentMap(Map<K, V> map, Object lock) {
        return new SynchronizedConcurrentMap<K, V>(map, lock);
    }

    public static <T> Iterable<T> unmodifiableIterable(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator it = iterable.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        return it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable toIterable(Object value) {
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        return UtilsConstants.toListPrivate(value);
    }

    public static Collection toCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return UtilsConstants.toListPrivate(value);
    }

    public static List toList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        return UtilsConstants.toListPrivate(value);
    }

    private static List<Object> toListPrivate(final Object value) {
        if (value != null && value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return new AbstractList<Object>(){

                    @Override
                    public Object get(int index) {
                        return Array.get(value, index);
                    }

                    @Override
                    public int size() {
                        return Array.getLength(value);
                    }

                    @Override
                    public Object set(int index, Object after) {
                        Object before = this.get(index);
                        Array.set(value, index, after);
                        return before;
                    }
                };
            }
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    public static List<String> toMessageList(Throwable throwable) {
        ArrayList<String> list = new ArrayList<String>();
        Throwable t = throwable;
        while (t != null) {
            String s = t.getLocalizedMessage();
            if (t.getCause() == null) {
                if (s != null) {
                    list.add(s);
                } else {
                    list.add(t.toString());
                }
            } else if (s != null && !t.getCause().toString().equals(s)) {
                list.add(s);
            }
            t = t.getCause();
        }
        return list;
    }
}

