/*
 * Decompiled with CFR 0.152.
 */
package woolpack.el;

import java.util.HashMap;
import java.util.Map;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.el.PropertyELFactory;

public class CachePropertyELFactory
implements PropertyELFactory {
    private static final Map<Class, Map<String, GettingEL>> getterMap = new HashMap<Class, Map<String, GettingEL>>();
    private static final Map<Class, Map<String, EL>> setterMap = new HashMap<Class, Map<String, EL>>();
    private final PropertyELFactory factory;

    public CachePropertyELFactory(PropertyELFactory factory) {
        factory.getClass();
        this.factory = factory;
    }

    public GettingEL newGetter(Class clazz, String propertyName) {
        GettingEL getter = null;
        Map<String, GettingEL> map1 = getterMap.get(clazz);
        if (map1 != null) {
            getter = map1.get(propertyName);
        }
        if (getter == null) {
            getter = this.factory.newGetter(clazz, propertyName);
            if (map1 == null) {
                map1 = new HashMap<String, GettingEL>();
                getterMap.put(clazz, map1);
            }
            map1.put(propertyName, getter);
        }
        return getter;
    }

    public EL newSetter(Class clazz, String propertyName) {
        EL setter = null;
        Map<String, EL> map1 = setterMap.get(clazz);
        if (map1 != null) {
            setter = map1.get(propertyName);
        }
        if (setter == null) {
            setter = this.factory.newSetter(clazz, propertyName);
            if (map1 == null) {
                map1 = new HashMap<String, EL>();
                setterMap.put(clazz, map1);
            }
            map1.put(propertyName, setter);
        }
        return setter;
    }

    public PropertyELFactory getFactory() {
        return this.factory;
    }
}

