/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import woolpack.dom.DomConstants;
import woolpack.dom.DomContext;
import woolpack.dom.Evaluable;
import woolpack.el.ArrayPathEL;
import woolpack.el.EL;
import woolpack.el.GettingEL;
import woolpack.el.MapEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvalNetMask
implements Evaluable<String> {
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");
    public static final GettingEL KEY = new ArrayPathEL(DomConstants.LOCAL_EL, (EL)new MapEL("woolpack.dom.NET_MASK"));
    private final GettingEL addressEL;
    private final int[] maskArray;

    public EvalNetMask(GettingEL addressEL, String netMask) {
        addressEL.getClass();
        netMask.getClass();
        this.maskArray = EvalNetMask.toArray(netMask);
        if (this.maskArray == null) {
            throw new IllegalArgumentException();
        }
        this.addressEL = addressEL;
    }

    public EvalNetMask(String netMask) {
        this(KEY, netMask);
    }

    private static int[] toArray(String s) {
        if (s == null) {
            return null;
        }
        Matcher m = pattern.matcher(s);
        if (!m.matches()) {
            return null;
        }
        int[] a = new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4))};
        return a;
    }

    @Override
    public String eval(DomContext context) {
        String address = (String)this.addressEL.getValue(context, String.class);
        int[] a = EvalNetMask.toArray(address);
        if (a == null) {
            return null;
        }
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] & this.maskArray[i];
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(a[0]);
        sb.append('.');
        sb.append(a[1]);
        sb.append('.');
        sb.append(a[2]);
        sb.append('.');
        sb.append(a[3]);
        return sb.toString();
    }
}

