/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Evaluable;
import woolpack.el.ELTargetRuntimeException;
import woolpack.el.GettingEL;
import woolpack.el.GettingELAdapter;

public class DomConstants {
    public static final Evaluable<String> EVAL_ID = new Evaluable<String>(){

        @Override
        public String eval(DomContext context) {
            return context.getId();
        }
    };
    public static final Evaluable<String> EVAL_NODE_NAME = new Evaluable<String>(){

        @Override
        public String eval(DomContext context) {
            return context.getNode().getNodeName();
        }
    };
    public static final GettingEL CONTAINER_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getContainer();
        }
    };
    public static final GettingEL SESSION_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getSession();
        }
    };
    public static final GettingEL LOCAL_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getLocal();
        }
    };
    public static final GettingEL CONFIG_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getConfig();
        }
    };
    public static final GettingEL INPUT_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getInput();
        }
    };
    public static final GettingEL REQUEST_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getRequest();
        }
    };
    public static final GettingEL APPLICATION_EL = new GettingELAdapter(){

        public Object getValue(Object root, Class clazz) throws ELTargetRuntimeException {
            return ((DomContext)root).getApplication();
        }
    };
    public static final DomExpression NULL = new DomExpression(){

        public void interpret(DomContext context) {
        }
    };
    public static final DomExpression REMOVE_THIS = new DomExpression(){

        public void interpret(DomContext context) {
            DomConstants.removeThis(context.getNode());
        }
    };
    public static final DomExpression REMOVE_CHILDREN = new DomExpression(){

        public void interpret(DomContext context) {
            DomConstants.removeChildren(context.getNode());
        }
    };
    public static final DomExpression RETAIN_CHILDREN = new DomExpression(){

        public void interpret(DomContext context) {
            DomConstants.retainChildren(context.getNode());
        }
    };
    public static final DomExpression CLEAR_SESSION = new DomExpression(){

        public void interpret(DomContext context) {
            context.getSession().clear();
        }
    };

    private DomConstants() {
    }

    public static void removeThis(Node node) {
        node.getParentNode().removeChild(node);
    }

    public static void removeChildren(Node node) {
        Node child = null;
        while ((child = node.getFirstChild()) != null) {
            node.removeChild(child);
        }
    }

    public static void retainChildren(Node node) {
        Node parent = node.getParentNode();
        Node child = null;
        while ((child = node.getFirstChild()) != null) {
            parent.insertBefore(child, node);
        }
        parent.removeChild(node);
    }

    public static void appendText(Node node, String text) {
        node.appendChild(DomConstants.getDocumentNode(node).createTextNode(text));
    }

    public static Document getDocumentNode(Node node) {
        return node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
    }
}

