/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.samples.aa;

import junit.framework.TestCase;
import woolpack.TestDomContextBuilder2;
import woolpack.samples.SamplesAllTests;

public class AAServletTest extends TestCase {
	
	public void testNormal(){
		final AAServlet servlet = new AAServlet();
		servlet.toNode.setExpression(SamplesAllTests.getFileToNode("^(.*)$", "html/sample/aa/$1.html"));
		final TestDomContextBuilder2 builder = new TestDomContextBuilder2(servlet.componentDefMap);
		
		builder.init();
		builder.get().setId("simple_loginInput");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'login\']"));
		
		builder.initXPath("//FORM");
		builder.getInput().get("loginName").set(0, "aa");
		builder.getInput().get("loginPassword").set(0, "aa");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'top\']"));

		builder.initXPath("//A[@href=\"common_top\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'top\']"));

		builder.initXPath("//A[@href=\"evenRole_result\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'even\']"));
		
		builder.init();
		builder.get().setId("common_top");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'top\']"));

		builder.initXPath("//A[@href=\"simple_logout\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'logout\']"));

		builder.initXPath("//A[@href=\"simple_loginInput\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'login\']"));
	}
	
	public void testEven(){
		final AAServlet servlet = new AAServlet();
		servlet.toNode.setExpression(SamplesAllTests.getFileToNode("^(.*)$", "html/sample/aa/$1.html"));
		final TestDomContextBuilder2 builder = new TestDomContextBuilder2(servlet.componentDefMap);
		
		builder.init();
		builder.get().setId("simple_loginInput");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'login\']"));
		
		builder.initXPath("//FORM");
		builder.getInput().get("loginName").set(0, "aa");
		builder.getInput().get("loginPassword").set(0, "aa");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'top\']"));

		builder.initXPath("//A[@href=\"oddRole_result\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//*[contains(text()[2], \'forbidden\')]"));

		builder.initXPath("//A[@href=\"simple_loginInput\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'login\']"));
	}
	
	public void testOdd(){
		final AAServlet servlet = new AAServlet();
		servlet.toNode.setExpression(SamplesAllTests.getFileToNode("^(.*)$", "html/sample/aa/$1.html"));
		final TestDomContextBuilder2 builder = new TestDomContextBuilder2(servlet.componentDefMap);
		
		builder.init();
		builder.get().setId("simple_loginInput");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'login\']"));
		
		builder.initXPath("//FORM");
		builder.getInput().get("loginName").set(0, "aaa");
		builder.getInput().get("loginPassword").set(0, "aaa");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'top\']"));

		builder.initXPath("//A[@href=\"oddRole_result\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'odd\']"));
		
		builder.init();
		builder.get().setId("common_top");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'top\']"));

		builder.initXPath("//A[@href=\"evenRole_result\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//*[contains(text()[2], \'forbidden\')]"));

		builder.initXPath("//A[@href=\"simple_loginInput\"]");
		servlet.domExpression.interpret(builder.get());
		assertTrue(builder.exists("//H4[text() = \'login\']"));
	}
}
