/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.concurrent.Semaphore;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.utils.Switchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrySemaphore
implements DomExpression {
    private final Switchable<String, Semaphore> map;
    private final DomExpression trueExpression;
    private final DomExpression falseExpression;

    public TrySemaphore(Switchable<String, Semaphore> map, DomExpression trueExpression, DomExpression falseExpression) {
        map.getClass();
        trueExpression.getClass();
        falseExpression.getClass();
        this.map = map;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    @Override
    public void interpret(DomContext context) {
        Semaphore semaphore = this.map.get(context.getId());
        if (semaphore != null) {
            if (semaphore.tryAcquire()) {
                try {
                    this.trueExpression.interpret(context);
                }
                finally {
                    semaphore.release();
                }
            } else {
                this.falseExpression.interpret(context);
            }
        } else {
            this.trueExpression.interpret(context);
        }
    }
}

