/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import woolpack.utils.MapBuilder;

import junit.framework.TestCase;

public class ValidNamesValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new ValidNamesValidator(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testValid(){
		final ValidatorExpression expression = new ValidNamesValidator(Arrays.asList("a0", "a2", "a4"));
		final ValidatorContext context = new ValidatorContext();

		context.setInputMap(MapBuilder.get(new HashMap<String,List<Object>>()).put("a0", Arrays.asList((Object)"v")).get());
		assertTrue(expression.interpret(context));

		context.setInputMap(MapBuilder.get(new HashMap<String,List<Object>>()).put("a1", Arrays.asList((Object)"v")).get());
		assertFalse(expression.interpret(context));
	}
	
	public void testAppendTo() throws IOException{
		final ValidatorExpression expression = new ValidNamesValidator(Arrays.asList("a0", "a2", "a4"));
		final StringBuilder sb = new StringBuilder();
		expression.appendTo(sb);
		assertEquals("new ValidNamesValidator([\"a0\",\"a2\",\"a4\"])", sb.toString());
	}
	
	public void testAddMessageTo(){
		final ValidatorExpression expression = new ValidNamesValidator(Arrays.asList("a0", "a2", "a4"));
		final Collection<String> expectedCollection = new ArrayList<String>();
		expression.addMessageTo(expectedCollection);
		assertTrue(expectedCollection.isEmpty());
	}
}
