/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;

import junit.framework.TestCase;

public class TmpKeyValidatorTest extends TestCase {

	public void testConstructor(){
		try{
			new TmpKeyValidator(null, ValidatorConstants.FALSE);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new TmpKeyValidator("", ValidatorConstants.FALSE);
			fail();
		}catch(final StringIndexOutOfBoundsException expected){
		}
		try{
			new TmpKeyValidator("key0", null);
			fail();
		}catch(final NullPointerException expected){
		}
	}

	public void testInterpret(){
		final CountValidator counter0 = new CountValidator(ValidatorConstants.FALSE);
		final ValidatorExpression expression = new TmpKeyValidator("key0", counter0);
		final ValidatorContext context = new ValidatorContext();
		
		assertFalse(expression.interpret(context));
		assertEquals(1, counter0.getIntepretCount());
		assertEquals("key0", counter0.getContextList().getLast().getTmpKey());
	}
	
	public void testAppendTo() throws IOException{
		final CountValidator counter0 = new CountValidator(ValidatorConstants.FALSE);
		final ValidatorExpression expression = new TmpKeyValidator("key1", counter0);
		final StringBuilder sb = new StringBuilder();
		expression.appendTo(sb);
		assertEquals("new TmpKeyValidator(\"key1\",new FalseValidator())", sb.toString());
		assertEquals(1, counter0.getAppendToCount());
		assertTrue(sb == counter0.getSbList().getLast());
	}
}
