/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.Format;
import java.text.ParseException;

import junit.framework.TestCase;

public class BooleanFormatTest extends TestCase {

	public void testConstructor(){
		try{
			new BooleanFormat(null, "false");
			fail();
		}catch(final NullPointerException e){
		}
		try{
			new BooleanFormat("", "false");
			fail();
		}catch(final StringIndexOutOfBoundsException e){
		}
		try{
			new BooleanFormat("true", null);
			fail();
		}catch(final NullPointerException e){
		}
		try{
			new BooleanFormat("true", "");
			fail();
		}catch(final StringIndexOutOfBoundsException e){
		}
	}
	
	private void scenario(final Format format) throws ParseException{
		assertEquals("True", format.format(Boolean.TRUE));
		assertEquals("False", format.format(Boolean.FALSE));
		assertEquals("False", format.format(new Integer(0)));
		assertEquals(Boolean.TRUE, format.parseObject("True"));
		assertEquals(Boolean.FALSE, format.parseObject("False"));
		assertEquals(Boolean.FALSE, format.parseObject("true"));
		assertEquals(Boolean.FALSE, format.parseObject("false"));
	}

	public void testNormal() throws ParseException{
		final Format format0 = new BooleanFormat("True", "False");
		scenario(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario(format1);
	}
	
	private void scenario2(final Format format) throws ParseException{
		assertEquals("true", format.format(Boolean.TRUE));
		assertEquals("false", format.format(Boolean.FALSE));
		assertEquals("false", format.format(new Integer(0)));
		assertEquals(Boolean.TRUE, format.parseObject("true"));
		assertEquals(Boolean.FALSE, format.parseObject("false"));
		assertEquals(Boolean.FALSE, format.parseObject("True"));
		assertEquals(Boolean.FALSE, format.parseObject("False"));
	}

	public void testNormal2() throws ParseException{
		final Format format0 = new BooleanFormat();
		scenario2(format0);
		final Format format1 = (Format)format0.clone();
		assertTrue(format0 != format1);
		scenario2(format1);
	}
}
