/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;

public class ReflectionPropertyELFactoryTest extends TestCase {

	public void testConstructor(){
		try{
			new ReflectionPropertyELFactory(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testEquals(){
		{
			final ReflectionPropertyELFactory obj = new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER);
			assertTrue(obj.equals(obj));
		}
		assertEquals(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER), new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER));
		assertFalse(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER).equals(new ReflectionPropertyELFactory(ELConstants.COLLECTION_CONVERTER)));
		assertFalse(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER).equals(new Object()));
		assertFalse(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER).equals(null));
	}
	
	public void testHashCode(){
		assertTrue(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER).hashCode() == new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER).hashCode());
		assertTrue(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER).hashCode() != new ReflectionPropertyELFactory(ELConstants.COLLECTION_CONVERTER).hashCode());
	}
	
	public void testToString(){
		assertEquals(
				"woolpack.el.ReflectionPropertyELFactory@@[convertEL=woolpack.el.SimpleTypeConvertEL@@]", 
				new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER).toString().replaceAll("@[a-z0-9]+", "@@"));
	}
}
