/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import junit.framework.TestCase;

public class CachePropertyELFactoryTest extends TestCase {

	public void testConstructor(){
		try{
			new CachePropertyELFactory(null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testEquals(){
		{
			final PropertyELFactory obj = new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER));
			assertTrue(obj.equals(obj));
		}
		assertTrue(
				new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER))
				.equals(new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER))));
		assertFalse(
				new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER))
				.equals(new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.COLLECTION_CONVERTER))));
		assertFalse(new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER)).equals(new Object()));
		assertFalse(new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER)).equals(null));
	}
	
	public void testHashCode(){
		assertTrue(
				new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER)).hashCode() ==  
					new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER)).hashCode());
		assertTrue(
				new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER)).hashCode() !=  
					new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.COLLECTION_CONVERTER)).hashCode());
	}
	
	public void testToString(){
		assertEquals(
				"woolpack.el.CachePropertyELFactory@@[factory=woolpack.el.ReflectionPropertyELFactory@@[convertEL=woolpack.el.SimpleTypeConvertEL@@]]", 
				new CachePropertyELFactory(new ReflectionPropertyELFactory(ELConstants.SIMPLE_CONVERTER)).toString().replaceAll("@[a-z0-9]+", "@@"));
	}
}
