/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

import woolpack.el.PathEL;
import junit.framework.TestCase;

public class IfTest extends TestCase {

	public void testConstructor(){
		try{
			new If(null, DomConstants.NULL, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new If(DomConstants.EVAL_NODE_NAME, null, DomConstants.NULL);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new If(DomConstants.EVAL_NODE_NAME, DomConstants.NULL, null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormal(){
		final Count counter0 = new Count(DomConstants.NULL);
		final Count counter1 = new Count(DomConstants.NULL);
		final DomExpression expression = new If(new EvalEL(null, new PathEL("context.local.key0")), counter0, counter1);
		final DomContext context = new DomContext();
		
		expression.interpret(context);
		assertEquals(0, counter0.getCount());
		assertEquals(0, counter1.getCount());
		
		context.getLocal().put("key0", Boolean.TRUE);
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
		assertEquals(context, counter0.getContextList().getLast());
		assertEquals(0, counter1.getCount());
		
		context.getLocal().put("key0", Boolean.FALSE);
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
		assertEquals(1, counter1.getCount());
		assertEquals(context, counter1.getContextList().getLast());
	}
	
	public void testNormal2(){
		final Count counter0 = new Count(DomConstants.NULL);
		final DomExpression expression = new If(new EvalEL(null, new PathEL("context.local.key0")), counter0);
		final DomContext context = new DomContext();
		
		expression.interpret(context);
		assertEquals(0, counter0.getCount());
		
		context.getLocal().put("key0", Boolean.TRUE);
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
		assertEquals(context, counter0.getContextList().getLast());
		
		context.getLocal().put("key0", Boolean.FALSE);
		expression.interpret(context);
		assertEquals(1, counter0.getCount());
	}
}
