/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import java.io.IOException;

/**
 * 検証条件の実行結果が false の場合に委譲先を実行する{@link ValidatorExpression}。
 * @author nakamura
 *
 */
public class IfNotValidator extends IfValidator {
	private final ValidatorExpression ifExpression;
	private final ValidatorExpression falseExpression;
	
	/**
	 * コンストラクタ。
	 * @param ifExpression 検証条件。
	 * @param falseExpression 検証条件の結果が false の場合の委譲先。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public IfNotValidator(final ValidatorExpression ifExpression, final ValidatorExpression falseExpression){
		super(new NotValidator(ifExpression), falseExpression);
		this.ifExpression = ifExpression;
		this.falseExpression = falseExpression;
	}

	@Override public void appendArgumentTo(final Appendable sb) throws IOException{
		ifExpression.appendTo(sb);
		sb.append(",");
		falseExpression.appendTo(sb);
	}
}
