/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.validator;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * キーとインデックスとメッセージと値を保持するだけのオブジェクト。
 * 本クラスはリクエストごとに生成することを想定している。
 * @author nakamura
 *
 */
public class AddressedMessage {
	private String key;
	private int index;
	private String message;
	private Object value;
	
	public AddressedMessage(){}
	
	public AddressedMessage(final String key, final int index, final String message, final Object value){
		this.key = key;
		this.index = index;
		this.message = message;
		this.value = value;
	}

	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public int getIndex() {
		return index;
	}
	public void setIndex(int index) {
		this.index = index;
	}
	public String getMessage() {
		return message;
	}
	public void setMessage(String message) {
		this.message = message;
	}
	public Object getValue() {
		return value;
	}
	public void setValue(Object value) {
		this.value = value;
	}

	@Override public int hashCode(){
		return new HashCodeBuilder()
		.append(key)
		.append(index)
		.append(message)
		.append(value)
		.toHashCode();
	}
	
	@Override public boolean equals(final Object obj){
		if(!(obj instanceof AddressedMessage)){
			return false;
		}
		if(this == obj){
			return true;
		}
		final AddressedMessage o = (AddressedMessage)obj;
		return new EqualsBuilder()
		.append(this.key, o.key)
		.append(this.index, o.index)
		.append(this.message, o.message)
		.append(this.value, o.value)
		.isEquals();
	}
	
	@Override public String toString(){
		return new ToStringBuilder(this)
		.append("key", key)
		.append("index", index)
		.append("message", message)
		.append("value", value)
		.toString();
	}
}
