/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

/**
 * {@link StringReader}を返す{@link ReaderFactory}。
 * @author nakamura
 *
 */
public class StringReaderFactory implements ReaderFactory {
	private final String s;
	
	/**
	 * コンストラクタ。
	 * @param s {@link StringReader}の引数に渡す文字列。
	 * @throws NullPointerException 引数が null の場合。
	 */
	public StringReaderFactory(final String s){
		s.getClass();
		this.s = s;
	}

	public Reader newInstance(final String id) throws IOException {
		return new StringReader(s);
	}
}
