/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.text;

import java.text.ParsePosition;

/**
 * 文字をフォーマットする変換器。
 * @author nakamura
 *
 */
public class ToCharacterFormat extends ToStringFormat {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * コンストラクタ。
	 *
	 */
	public ToCharacterFormat(){
	}

	@Override
	public Object parseObject(final String source, final ParsePosition pos) {
//		if(source.length() <= pos.getIndex()){
//			pos.setErrorIndex(pos.getIndex());
//			return null;
//		}
		final char c = source.charAt(pos.getIndex());
		pos.setIndex(pos.getIndex()+1);
		return new Character(c);
	}

	@Override public Object clone(){
		return new ToCharacterFormat();
	}
	
	/**
	 * JavaScriptのコンストラクタ表現を返す。
	 */
	@Override public String toString(){
		return "new ToCharacterFormat()";
	}
}
