/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.locale;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

import org.w3c.dom.Node;

import woolpack.dom.CacheNode;
import woolpack.dom.DomExpression;

/**
 * {@link Locale}で DOM ノードをキャッシュし現在のスレッドの{@link Locale}でキャッシュを取り出す{@link CacheNode}。
 * @author nakamura
 *
 */
public class LocaleCacheNode extends CacheNode {
	private final ThreadLocal<Locale> threadLocal;

	/**
	 * コンストラクタ。
	 * @param cacheMap キャッシュ。本クラスはこの引数の状態を変化させる。null が指定された場合はキャッシュを行わない。{@link LinkedHashMap#removeEldestEntry(java.util.Map.Entry)}を指定した{@link LinkedHashMap}を指定するとキャッシュの容量を制御することができる。{@link java.util.HashMap}などの強参照の{@link Map}を指定すると容量制限のないキャッシュになる。{@link java.util.WeakHashMap}を指定すると弱参照によるキャッシュになる。
	 * @param nodeMaker DOM ノードを生成し加工する委譲先。
	 * @param threadLocal 現在のスレッドの{@link Locale}を保持する{@link ThreadLocal}。本クラスはこの引数の状態を変化させない。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 */
	public LocaleCacheNode(final Map<Object,Node> cacheMap, final DomExpression nodeMaker, final ThreadLocal<Locale> threadLocal) {
		super(cacheMap, nodeMaker);
		threadLocal.getClass();
		this.threadLocal = threadLocal;
	}

	@Override public Object getCacheKey(final String id){
		final Map<String,Object> map = new HashMap<String, Object>(2);
		map.put("id", id);
		map.put("locale", threadLocal.get());
		return map;
	}
}
