/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.Map;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * {@link Map}のみをサポートする{@link EL}。
 * @author nakamura
 *
 */
public class MapEL extends ELAdapter {
	private final String key;
	private final GettingEL convertEL;
	
	/**
	 * コンストラクタ。
	 * @param key キー。
	 * @param convertEL 型変換器。
	 * @throws NullPointerException 引数のいずれかが null の場合。
	 * @throws StringIndexOutOfBoundsException key が空の場合。
	 */
	public MapEL(final String key, final GettingEL convertEL){
		key.charAt(0);
		convertEL.getClass();
		
		this.key = key;
		this.convertEL = convertEL;
	}

	/**
	 * コンストラクタ。
	 * @param key キー。
	 * @throws NullPointerException 引数が null の場合。
	 * @throws StringIndexOutOfBoundsException 引数が空の場合。
	 */
	public MapEL(final String key){
		this(key, ELConstants.COLLECTION_CONVERTER);
	}

	@Override public void setValue(final Object root, final Object value)
			throws ELTargetRuntimeException {
		((Map)root).put(key, value);
	}

	@Override public Object getValue(final Object root, final Class toType) throws ELTargetRuntimeException {
		final Object result = ((Map)root).get(key);
		return convertEL.getValue(result, toType);
	}
	
	@Override public int hashCode(){
		return new HashCodeBuilder().append(key).append(convertEL).toHashCode();
	}
	
	@Override public boolean equals(final Object obj){
		if(!(obj instanceof MapEL)){
			return false;
		}
		if(this == obj){
			return true;
		}
		final MapEL o = (MapEL)obj;
		return new EqualsBuilder()
		.append(this.key, o.key)
		.append(this.convertEL, o.convertEL)
		.isEquals();
	}
	
	@Override public String toString(){
		return new ToStringBuilder(this).append("key", key).append("convertEL", convertEL).toString();
	}
}
