/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

/**
 * 定数の集まり。
 * @author nakamura
 *
 */
public class ELConstants {
	
	/**
	 * 単純型コンバータのデフォルト値。
	 */
	public static final GettingEL SIMPLE_CONVERTER = new SimpleTypeConvertEL();

	/**
	 * 一覧型コンバータのデフォルト値。
	 */
	public static final GettingEL COLLECTION_CONVERTER = new CollectionTypeConvertEL(SIMPLE_CONVERTER);
	
	/**
	 * プロパティにアクセスする{@link GettingEL}と{@link EL}のファクトリのデフォルト値。
	 */
	public static final PropertyELFactory PROPERTY_EL_FACTORY = 
		new MapPropertyELFactory(COLLECTION_CONVERTER, new CachePropertyELFactory(
				new ReflectionPropertyELFactory(COLLECTION_CONVERTER)));

	/**
	 * null オブジェクト役の{@link EL}。
	 */
	public static final EL NULL = new ELAdapter(){
		@Override
		public Object getValue(final Object root, final Class toType) throws ELTargetRuntimeException {
			return null;
		}
		@Override
		public void setValue(final Object root, final Object value) throws ELTargetRuntimeException {
			// do nothing.
		}
	};

	private ELConstants(){}// カバレージがここを通過してはいけない
}
