/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.dom;

/**
 * DOM ノードを加工する機能を拡張するために使用する、 インタープリタ デザインパターンの Expression 役。
 * 実装クラスのコンストラクタツリーは複数のスレッド/複数の J2EE セッションから同時に実行されることを想定しているため
 * リエントラントである必要がある。
 * よって以下のケースを除いて実装クラスは状態を持たないべきである。
 * (1)複数のスレッドまたは複数の J2EE セッションの並行性を制御するクラス(セマフォにより同時実行を制御するクラスなどが挙げられる)。
 * (2)ユーザから見てステートレスであるクラス(オブジェクトをキャッシュするクラスなどが挙げられる)。
 * (3)カウンタなどテストで使用するクラス。
 * ステートレスな実装クラスを作成する際、コンストラクタ引数の不変性に注意する必要がある。
 * 特にある引数の型にコレクションフレームワークのインターフェイス(Map/List/Set/Collection/Iterable)をとる場合は
 * 実装クラスでコピーをとるか引数に渡した後に状態を変更しない必要がある。
 * @author nakamura
 *
 */
public interface DomExpression {
	/**
	 * DOM ノードを加工するために呼び出される(called)。
	 * 実装クラスでは、引数が null でないことを前提としてよい。
	 * 実装クラスで{@link RuntimeException}のサブ例外が発生する場合は JavaDoc コメントに記載すると部品の可用性が維持される。
	 * @param context Context 役。
	 */
	public void interpret(DomContext context);
}
