/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.config;

import java.util.Map;

/**
 * 設定内容を格納した{@link Map}を加工する機能を拡張するために使用する インタープリタ デザインパターンの Expression 役。
 * 実装クラスのコンストラクタツリーは複数のスレッド/複数の J2EE セッションから同時に実行されることを想定しているため
 * リエントラントである必要がある。
 * @author nakamura
 *
 */
public interface ConfigExpression {
	/**
	 * {@link Map}を加工するために呼び出される(called)。
	 * 実装クラスでは、引数が null でないことを前提としてよい。
	 * 実装クラスで{@link RuntimeException}のサブ例外が発生する場合は JavaDoc コメントに記載すると部品の可用性が維持される。
	 * @param context Context 役。
	 */
	public void interpret(ConfigContext context);
}
