/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.html;

import junit.framework.TestCase;
import woolpack.TestUtils;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;
import woolpack.dom.Serial;

public class HtmlConstantsTest extends TestCase {

	public void testNormalize(){
		final DomExpression expression = new Serial(
				TestUtils.getToNode("<html><BODY><sPaN attra=\"valuea\" ATTRB=\"VALUEB\" attrC=\"valueC\">aBcD</sPaN></BODY></html>"),
				HtmlConstants.NORMALIZE
		);
		final DomContext context = new DomContext();
		expression.interpret(context);

		assertTrue(TestUtils.equals(context, "<HTML><BODY><SPAN attra=\"valuea\" attrb=\"VALUEB\" attrc=\"valueC\">aBcD</SPAN></BODY></HTML>"));
	}
}
