/*
 * Copyright 2006 Takahiro Nakamura.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package woolpack.el;

import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import woolpack.utils.MapBuilder;

public class PathELTest extends TestCase {

	public void testConstructor(){
		try{
			new PathEL(null, TypeConverter.NOP);
			fail();
		}catch(final NullPointerException expected){
		}
		try{
			new PathEL("key0", null);
			fail();
		}catch(final NullPointerException expected){
		}
	}
	
	public void testNormalMap(){
		final Map<String,Object> map = MapBuilder.get(new HashMap<String,Object>())
		.put("key0", 
				MapBuilder.get(new HashMap<String,Object>())
				.put("key1", new Integer(3))
				.get())
		.get();
		
		final EL el = new PathEL("key0.key1", TypeConverter.NOP);
		
		assertEquals(new Integer(3), el.getValue(map));
		assertEquals(new Integer(3), el.getValue(map, String.class));
		
		el.setValue(map, "valuee01a");
		assertEquals("valuee01a", el.getValue(map));
	}
	
	public void testEquals(){
		assertEquals(new PathEL("key0").hashCode(), new PathEL("key0").hashCode());
		assertEquals(new PathEL("key0"), new PathEL("key0"));
		assertFalse(new PathEL("key0").equals(new PathEL("key1")));
		assertEquals(new PathEL("key0.key1").hashCode(), new PathEL("key0.key1").hashCode());
		assertEquals(new PathEL("key0.key1"), new PathEL("key0.key1"));
		assertFalse(new PathEL("key0.key1").equals(new PathEL("key0.key2")));
		assertFalse(new PathEL("key0.key1").equals(new PathEL("key2.key1")));
		assertFalse(new PathEL("key0.key1").equals(new PathEL("key0.key1.key2")));
		assertFalse(new PathEL("key0.key1").equals(new Object()));
	}
}
